/*---------------------------------------------------------------*/

#include "typesiigs.r" 

/*------------------- Values used through out -------------------*/

#define MainWindow              $1000
#define SFWindow                $1001
 
#define CheckFolderAllSee       $0101
#define CheckFileAllSee         $0102
#define CheckAllChanges         $0103
#define CheckFolderGroupSee     $0104
#define CheckFileGroupSee       $0105
#define CheckGroupChanges       $0106
#define CheckFolderOwnerSee     $0107
#define CheckFileOwnerSee       $0108
#define CheckOwnerChanges       $0109
#define UndoBut                 $010A
#define SaveBut                 $010B
#define ViewAnotherBut          $010C
#define CheckLocked             $010D
#define LEOwnerName             $010E
#define LEGroupName             $010F
#define StatTextTextID1         $0110
#define StatTextTextID2         $0111
#define StatTextTextID3         $0112
#define StatTextTextID4         $0113
#define StatTextTextID5         $0114
#define StatTextTextID6         $0115
#define Owner                   $0116
#define Group                   $0117
#define Everyone                $0118
#define SeeFolders              $0119
#define SeeFiles                $011A
#define MakeChanges             $011B

/*----------------------- About Box ------------------------------*/
resource rAlertString (1) {
    "\$00\$19\$00\$A0\$00\$AA\$00\$E0\$01"
    "\$00/"
    TBCenterJust
    TBStyleOutline
    "Access Privileges"
    TBEndOfLine
    TBStylePlain
    TBEndOfLine
    "by"
    TBEndOfLine
    "Dan Strnad"
    TBEndOfLine
    TBEndOfLine
    "Copyright 1989 Apple Computer, Inc."
    TBEndOfLine
    "All Rights Reserved"
    TBEndOfLine
    "Version 3.0/^#6\$00"
};

/*----------------------Startup Record ---------------------------*/
resource rToolStartup (1)   {
    mode640,                            /* master SCB */
    {   
        3,$0300,                        /* misc tools */
        4,$0301,                        /* quickdraw */
        5,$0302,                        /* desk manager */
        6,$0300,                        /* eventMgr */
/*      7,$0200,                        /* scheduler */
/*      8,$0301,                        /* sound tools */
/*      9,$0201,                        /* ADB tools */
/*      10,$0202,                       /* SANE */
        11,$0200,                       /* int math */
        14,$0301,                       /* Window Manager */
        15,$0301,                       /* Menu Manager */
        16,$0301,                       /* Control Manager */
        18,$0301,                       /* QD Aux */
        19,$0300,                       /* print manager */
        20,$0301,                       /* LineEdit tool set */
        21,$0302,                       /* Dialog Manager */
        22,$0300,                       /* Scrap manager */
        23,$0301,                       /* standard file */
/*      25,$0104,                       /* NoteSynth */
/*      26,$0104,                       /* Note Seq */
        27,$0301,                       /* Font manager */
        28,$0301,                       /* list manager */
/*      29,$0101,                       /* ACE */
/*      32,$0103,                       /* Midi Tools */
/*      34,$0101                        /* text edit */
    }
};

/*---------------------------------------------------------------------------*/
/*
/* Main Window
/*
/* This is the template for the privileges window 
/*
/*---------------------------------------------------------------------------*/
resource rWindParam1 (MainWindow) {
    fTitle+fVis,                                    /* Frame Bits           */
    0x201,                                          /* title ID             */
    0,                                              /* ref Con              */
    {0,0,0,0},                                      /* Zoom Rect            */
    0,                                              /* color table id       */
    {0,0},                                          /* origin               */
    {0,0},                                          /* data size            */
    {0,0},                                          /* max height-width     */
    {0,0},                                          /* scroll amount, hor,ver */
    {0,0},                                          /* page amount */
    0,                                              /* wInfo Ref Con */
    0,                                              /* wInfo height */
    {30,50,192,550},                                /* window Position */
    infront,                                        /* wPlane */
    MainWindow,                                     /* Control Ref */
    refIsResource*0x0100+resourceToResource         /* descriptor */
};

/*---------------------------------------------------------------------------*/
/* This is the title of the main window
/*---------------------------------------------------------------------------*/
resource rPString (0x201) {
    "Access Privileges"
    };

/*---------------------------------------------------------------------------*/
/* The following define the controls for the main window.
/* First I start with some constants.
/*---------------------------------------------------------------------------*/

#Define RowSep      9
#Define RowSep2     18
#Define RowSep3     24
#Define RowSep4     15
#Define RowSep5     8

#Define TextRow1    4
#Define TextRow2    TextRow1 + RowSep
#Define TextRow3    TextRow2 + RowSep
#Define TextRow4    TextRow3 + RowSep 
#Define TextRow5    TextRow4 + RowSep2
#Define TextRow6    TextRow5 + RowSep2
#Define TextRow7    TextRow6 + RowSep3
#Define TextRow8    TextRow7 + RowSep2
#Define TextRow9    TextRow8 + RowSep2
#Define TextRow10   TextRow9 + RowSep4

#Define CtrlCol1    10
#Define CtrlCol2    200
#Define CtrlCol3    300
#Define CtrlCol4    400
#Define CtrlCol5    180
#Define ButWidth        140
#Define ButHeight       12
#Define ButSep          20
#Define ButVSep         5

#Define TopOfButRow      TextRow9 + RowSep2
#Define BottomOfButRow   TopOfButRow+ButHeight

#Define ButLeftEdge1         ButSep
#Define ButRightEdge1        ButLeftEdge1+ButWidth
#Define ButLeftEdge2         ButRightEdge1+ButSep
#Define ButRightEdge2        ButLeftEdge2+ButWidth
#Define ButLeftEdge3         ButRightEdge2+ButSep
#Define ButRightEdge3        ButLeftEdge3+ButWidth

#Define LEHeight            14
#Define LEWidth             270


/* List of all controls in Main Window */

resource rControlList (MainWindow) {
    {
        CheckLocked,
        LEOwnerName,
        LEGroupName,
        CheckFolderAllSee,
        CheckFolderGroupSee,
        CheckFolderOwnerSee,
        CheckFileAllSee,
        CheckFileGroupSee,
        CheckFileOwnerSee,
        CheckAllChanges,
        CheckGroupChanges,
        CheckOwnerChanges,
        UndoBut,
        SaveBut,
        ViewAnotherBut,
        StatTextTextID1,
        StatTextTextID2,
        StatTextTextID3,
        StatTextTextID4,
        StatTextTextID5,
        StatTextTextID6
    };
};


resource rControlTemplate (CheckLocked)  {
    CheckLocked,                                     /* control ID */
    {TextRow5,CtrlCol1,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        CheckLocked,                                 /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 

resource rpString (CheckLocked) {
    "Locked"
};

resource rControlTemplate (LEOwnerName)  {
    LEOwnerName,                                            /* control ID */
    {TextRow5,CtrlCol2,TextRow5+LEHeight,CtrlCol2+LEWidth}, /* control rect */
    EditLineControl{{                                       /* control type */
        0,                                                  /* Flag */
        fctlProcNotPtr+refIsResource,                       /* More Flags */
        0,                                                  /* ref con */
        32,                                                 /* Max Length */
        LEOwnerName                                         /* Init Value Ref*/
    }};
}; 

resource rpString (LEOwnerName) {
    ""
};

resource rControlTemplate (LEGroupName)  {
    LEGroupName,                                            /* control ID */
    {TextRow6,CtrlCol2,TextRow6+LEHeight,CtrlCol2+LEWidth}, /* control rect */
    EditLineControl{{                                       /* control type */
        0,                                                  /* Flag */
        fctlProcNotPtr+refIsResource,                       /* More Flags */
        0,                                                  /* ref con */
        32,                                                 /* Max Length */
        LEGroupName                                         /* Init Value Ref*/
    }};
}; 

resource rpString (LEGroupName) {
    ""
};

resource rpString (Owner) {
    "Owner"
};

resource rpString (Group) {
    "Group"
};

resource rpString (Everyone) {
    "Everyone"
};

resource rControlTemplate (CheckFolderOwnerSee)  {
    CheckFolderOwnerSee,                             /* control ID */
    {TextRow7,CtrlCol2,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        Owner,                                       /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 

resource rControlTemplate (CheckFolderGroupSee)  {
    CheckFolderGroupSee,                             /* control ID */
    {TextRow7,CtrlCol3,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        Group,                                       /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 

resource rControlTemplate (CheckFolderAllSee)  {
    CheckFolderAllSee,                               /* control ID */
    {TextRow7,CtrlCol4,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        Everyone,                                    /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 

resource rControlTemplate (CheckFileOwnerSee)  {
    CheckFileOwnerSee,                               /* control ID */
    {TextRow8,CtrlCol2,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        Owner,                                       /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 

resource rControlTemplate (CheckFileGroupSee)  {
    CheckFileGroupSee,                               /* control ID */
    {TextRow8,CtrlCol3,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        Group,                                       /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 

resource rControlTemplate (CheckFileAllSee)  {
    CheckFileAllSee,                                 /* control ID */
    {TextRow8,CtrlCol4,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        Everyone,                                    /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 

resource rControlTemplate (CheckOwnerChanges)  {
    CheckOwnerChanges,                               /* control ID */
    {TextRow9,CtrlCol2,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        Owner,                                       /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 

resource rControlTemplate (CheckGroupChanges)  {
    CheckGroupChanges,                               /* control ID */
    {TextRow9,CtrlCol3,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        Group,                                       /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 

resource rControlTemplate (CheckAllChanges)  {
    CheckAllChanges,                                 /* control ID */
    {TextRow9,CtrlCol4,0,0},                         /* control rect */
    CheckControl{{                                   /* control type */
        0,                                           /* flag */
        fctlProcNotPtr+refIsResource,                /* more flags */
        0,                                           /* ref con */
        Everyone,                                    /* title ref */
        1,                                           /* initial value */
        0,                                           /* color table not used */
        {"","",0,0}                                  /* key equiv */
    }};
}; 



/* The definition of the buttons button */
resource rControlTemplate (UndoBut)  {
    UndoBut,                                                  /* control ID */
    {TopOfButRow,ButLeftEdge1,BottomOfButRow,ButRightEdge1},  /* control rect*/
    SimpleButtonControl{{                                     /* control type*/
        0,                                                    /* flag */
        0x1002,                                               /* more flags */
        0,                                                    /* ref con */
        UndoBut                                               /* title ref */
    }};
};

/* The definition of the buttons button */
resource rControlTemplate (SaveBut)  {
    SaveBut,                                                  /* control ID */
    {TopOfButRow,ButLeftEdge2,BottomOfButRow,ButRightEdge2},  /* control rect*/
    SimpleButtonControl{{                                     /* control type*/
        0,                                                    /* flag */
        0x1002,                                               /* more flags */
        0,                                                    /* ref con */
        SaveBut                                               /* title ref */
    }};
};

/* The definition of the buttons button */
resource rControlTemplate (ViewAnotherBut)  {
    ViewAnotherBut,                                           /* control ID */
    {TopOfButRow,ButLeftEdge3,BottomOfButRow,ButRightEdge3},  /* control rect*/
    SimpleButtonControl{{                                     /* control type*/
        0,                                                    /* flag */
        0x1002,                                               /* more flags */
        0,                                                    /* ref con */
        ViewAnotherBut                                        /* title ref */
    }};
};

resource rpString (UndoBut) {
    "Undo"
};

resource rpString (SaveBut) {
    "Save"
};

resource rpString (ViewAnotherBut) {
    "View Another"
};

/*********************************************************************/
/*
/*          Menus
/*
/*********************************************************************/

#define AppleMenuID     $1100
#define FileMenuID      $1200

#Define AboutID         $1101
#define QuitID          $1201


resource rMenuBar (1) {
    {
        AppleMenuID,
        FileMenuID,
    };
};

resource rMenu (AppleMenuID)    {
    AppleMenuID,
    0xA008,
    AppleMenuID,
    { AboutID };
};

resource rMenu (FileMenuID) {
    FileMenuID,
    0xA008,
    FileMenuID,
    { QuitID };
};


resource rMenuItem (AboutID)    {
    AboutID,
    "","",
    0,
    0x8040,
    AboutID
};

resource rMenuItem (QuitID) {
    QuitID,
    "Q","q",
    0,
    0x8000,
    QuitID
};


resource rPString (AppleMenuID) {
    "@"
    };
resource rPString (FileMenuID) {
    " File "
    };
resource rPString (AboutID) {
    "About Access Privileges..."
    };
resource rPString (QuitID) {
    "Quit"
    };

/* Template for static text in main window */
resource rControlTemplate (StatTextTextID1)  {
    StatTextTextID1,                                    /* control ID */
    {4,0,40,190},                                       /* control rectangle */
    StatTextControl{{                                   /* control type */
        0xFF00,                                         /* flag */
        fctlProcNotPtr+refIsResource,                   /* more flags */
        0,                                              /* ref con */
        StatTextTextID1                                 /* title ref */
    }};
}; 

/* The static text for list window */
resource rTextForLETextBox2 (StatTextTextID1) {
        TBRightJust
        "Folder:"
        TBEndOfLine
        "On volume:"
        TBEndOfLine
        "Logged in as:"
        TBEndOfLine
        "Your privileges are:"
        TBEndOfLine
};

/* Template for static text in main window */
resource rControlTemplate (StatTextTextID2)  {
    StatTextTextID2,                                    /* control ID */
    {82,0,138,190},                                     /* control rectangle */
    StatTextControl{{                                   /* control type */
        0xFF00,                                         /* flag */
        fctlProcNotPtr+refIsResource,                   /* more flags */
        0,                                              /* ref con */
        StatTextTextID2                                 /* title ref */
    }};
}; 

/* The static text for list window */
resource rTextForLETextBox2 (StatTextTextID2) {
        TBRightJust
        TBEndOfLine
        "See Folders:"
        TBEndOfLine
        TBEndOfLine
        "See Files:"
        TBEndOfLine
        TBEndOfLine
        "Make Changes:"
        TBEndOfLine
};

/* Template for static text in main window */
resource rControlTemplate (StatTextTextID3)  {
    StatTextTextID3,                                    /* control ID */
    {40,90,77,190},                                     /* control rectangle */
    StatTextControl{{                                   /* control type */
        0xFF00,                                         /* flag */
        fctlProcNotPtr+refIsResource,                   /* more flags */
        0,                                              /* ref con */
        StatTextTextID3                                 /* title ref */
    }};
}; 

/* The static text for list window */
resource rTextForLETextBox2 (StatTextTextID3) {
        TBRightJust
        TBEndOfLine
        "Owner:"
        TBEndOfLine
        TBEndOfLine
        "Group:"
};

/* Template for static text in main window */
resource rControlTemplate (StatTextTextID4)  {
    StatTextTextID4,                                    /* control ID */
    {4,198,40,544},                                     /* control rectangle */
    StatTextControl{{                                   /* control type */
        0xFF00+fSubstituteText,                         /* flag */
        fctlProcNotPtr+refIsResource,                   /* more flags */
        0,                                              /* ref con */
        StatTextTextID4                                 /* title ref */
    }};
}; 

/* The static text for list window */
resource rTextForLETextBox2 (StatTextTextID4) {
        TBLeftJust
        "*0"
        TBEndOfLine
        "*1"
        TBEndOfLine
        "*2"
        TBEndOfLine
        "*3"
        TBEndOfLine
};

/* Template for static text in main window */
resource rControlTemplate (StatTextTextID5)  {
    StatTextTextID5,                                        /* control ID */
    {TextRow5,CtrlCol2,TextRow5+RowSep,CtrlCol2+LEWidth},   /* control rect */
    StatTextControl{{                                       /* control type */
        0xFF00+fSubstituteText,                             /* flag */
        fctlProcNotPtr+refIsResource,                       /* more flags */
        0,                                                  /* ref con */
        StatTextTextID5                                     /* title ref */
    }};
}; 

/* The static text for list window */
resource rTextForLETextBox2 (StatTextTextID5) {
        TBLeftJust
        "*4"
};

/* Template for static text in main window */
resource rControlTemplate (StatTextTextID6)  {
    StatTextTextID6,                                        /* control ID */
    {TextRow6,CtrlCol2,TextRow6+RowSep,CtrlCol2+LEWidth},   /* control rect */
    StatTextControl{{                                       /* control type */
        0xFF00+fSubstituteText,                             /* flag */
        fctlProcNotPtr+refIsResource,                       /* more flags */
        0,                                                  /* ref con */
        StatTextTextID6                                     /* title ref */
    }};
}; 

/* The static text for list window */
resource rTextForLETextBox2 (StatTextTextID6) {
        TBLeftJust
        "*5"
};
